/*
 * Decompiled with CFR 0.152.
 */
package mezz.modnametooltip;

import java.util.EnumSet;
import java.util.Locale;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String CATEGORY_FORMATTING = "formatting";
    private final ForgeConfigSpec config;
    private final ForgeConfigSpec.ConfigValue<String> modNameFormatFriendly;
    @Nullable
    private String cachedModNameFormat;

    public Config() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        EnumSet<ChatFormatting> validFormatting = EnumSet.allOf(ChatFormatting.class);
        validFormatting.remove(ChatFormatting.RESET);
        StringJoiner validColorsJoiner = new StringJoiner(", ");
        StringJoiner validFormatsJoiner = new StringJoiner(", ");
        for (ChatFormatting chatFormatting : validFormatting) {
            String lowerCaseName = chatFormatting.m_126666_().toLowerCase(Locale.ENGLISH);
            if (chatFormatting.m_126664_()) {
                validColorsJoiner.add(lowerCaseName);
                continue;
            }
            if (!chatFormatting.m_126661_()) continue;
            validFormatsJoiner.add(lowerCaseName);
        }
        String validColors = validColorsJoiner.toString();
        String validFormats = validFormatsJoiner.toString();
        builder.push(CATEGORY_FORMATTING);
        this.modNameFormatFriendly = builder.comment(new String[]{"How the mod name should be formatted in the tooltip. Leave blank to disable.", "Use these formatting colors:", validColors, "With these formatting options:", validFormats}).translation("config.modnametooltip.formatting.modNameFormat").define("modNameFormat", (Object)"blue italic");
        this.config = builder.build();
    }

    public ForgeConfigSpec getConfigSpec() {
        return this.config;
    }

    public String getModNameFormat() {
        if (this.cachedModNameFormat == null) {
            this.cachedModNameFormat = Config.parseFriendlyModNameFormat((String)this.modNameFormatFriendly.get());
        }
        return this.cachedModNameFormat;
    }

    private static String parseFriendlyModNameFormat(String formatWithEnumNames) {
        String[] strings;
        if (formatWithEnumNames.isEmpty()) {
            return "";
        }
        StringBuilder format = new StringBuilder();
        for (String string : strings = formatWithEnumNames.split(" ")) {
            ChatFormatting valueByName = ChatFormatting.m_126657_((String)string);
            if (valueByName != null) {
                format.append(valueByName);
                continue;
            }
            LOGGER.error("Invalid format: " + string);
        }
        return format.toString();
    }

    public void onConfigChanged(ModConfigEvent event) {
        if ("modnametooltip".equals(event.getConfig().getModId())) {
            this.cachedModNameFormat = null;
        }
    }
}

